function [objres,reg] = l1_obj(X,y,lss,lambda,w,dlta)

% lss: loss function
% 1: 'hinge'
% 2: 'logistic'
% 3: 'least square'
% 4: 'huber'
% 5: 'squared hinge'

 pred=w*X;

 if lss == 1 %'hinge'
    objres = max(0, 1 - pred.* y);
 end 

 if lss == 2 % 'logistic'
    objres = log(1+exp(-y.*pred));
 end
 
 if lss == 4 % 'least square'
    objres =  0.5*(pred - y).^2;
 end

 if lss == 4 % 'huber'
    objres = pred - y;
    id1 = find(abs(objres)<=dlta);
    id2 = find(abs(objres)>dlta);
    objres(id1) = 0.5*objres(id1).^2;
    objres(id2) = dlta*(abs(objres(id2)) - 0.5*dlta);
 end

 if lss == 5 % 'squared hinge'
    objres = max(0, 1 - pred.* y);
    objres = objres.^2;	
 end

 reg = lambda*sum(abs(w));
 objres = mean(objres) + reg;
