function [Obj,it,avgw]=ASSG(X, y, lss, eta0, w0, D0, t,K,b,gamm,dlta,...
                       epsilon,dense,prox,idx,evalk)

[d,n]=size(X);
if eta0==0
    eta0 = 1./max(sum(X.*X,1));
end
if isempty(w0)
    w0=zeros(1,d);
end
avgw=w0;
eps0=l1_obj(X,y,lss,gamm,avgw,dlta);
if epsilon<1
    eps = epsilon;
    K=ceil(log2(eps0/eps));
end
if isempty(idx)
    idx=randsample(n, K*t, true);
end
disp(sprintf('epoch=%d, obj=%.15f', 0, eps0));
Obj=[];
count=1;
it=[];
T = 0;
Time = 0;
Tcpu = 0;
if prox == 0 % 'ASSG'
   eta = eta0*eps0/3;
elseif prox == 1  % 'ProxASSG'
   eta = eta0*eps0/4;
end
D = D0*eps0;
 
for k=1:K
    st1 = tic;
    st2 = cputime;
    w = w0;
    indexMap = find(w0);
    if dense ~= 1 
     indw = indexMap;
    end
    
    for tau=1:t
        i=idx(count); 
        count=count+1; 
        [g,ind] = loss_grad(X(:,i),y(i),w,d,lss,dlta); 
        % ind: sparsity index of g
        % g: not not neccesary d-dimension			
        if prox == 0  %'ASSG'
            if dense == 1
            % Dense Version
                w = w - (eta*gamm)*sign(w);
            else 
            % Sparse Version
                w(indw)= w(indw) - (eta*gamm)*sign(w(indw)); % l1-norm regulerizer
            end
            w(ind) = w(ind) - eta*g;
            w = map(w0,D,w,indexMap);                   
        elseif prox == 1  %'ProxASSG'
            w(ind) = w(ind) - eta*g;
            w = l1_soft(w,gamm*eta);
            w = map(w0,D,w,indexMap);
        end
        
        if dense == 1 
        % Dense 
           avgw = avgw + w;
        else  
        % Sparse
           ind = find(w);
           avgw(ind) = avgw(ind) + w(ind);
        end
    end

    Tcpu = Tcpu + (cputime-st2);
    it(k,1) = Tcpu; % cpu time

    Time = Time + toc(st1);
    it(k,2) = Time; % running time

    T = T + t;
    it(k,3) = T; % iteraction 

    avgw=avgw/(t+1);
    w0 = avgw; 
    eta = eta/b;
    D = D/b;
    if mod(k, evalk)==0
      Obj(k/evalk) = l1_obj(X, y, lss,gamm, avgw, dlta);
      disp(sprintf('epoch=%d, obj=%.15f, T=%d,cpu=%d, time=%d', ...
            k/evalk, Obj(k/evalk),ceil(T),ceil(Tcpu),ceil(Time)));
    end
end



