/*
 * Decompiled with CFR 0.152.
 */
package rvl.util;

import rvl.util.Utility;

public class MoreMath {
    public static double logGamma(double d) {
        if (d <= 0.0) {
            Utility.warning("logGamma: argument must be > 0");
            return Double.NaN;
        }
        if (d < 15.0) {
            return MoreMath.logGamma(d + 1.0) - Math.log(d);
        }
        double d2 = 1.0 / (d * d);
        return (d - 0.5) * Math.log(d) - d + 0.9189385332046727 + (1.0 - d2 * (1.0 - d2 * (1.0 - 0.75 * d2) / 3.5) / 30.0) / 12.0 / d;
    }

    public static double gamma(double d) {
        return Math.exp(MoreMath.logGamma(d));
    }

    public static double beta(double d, double d2) {
        return Math.exp(MoreMath.logGamma(d + d2) - MoreMath.logGamma(d) - MoreMath.logGamma(d2));
    }
}

