/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface.apps;

import rvl.piface.Piface;
import rvl.stat.dist.T;

public class OneTGUI
extends Piface {
    private static String title = "One-sample (or paired) t test";
    public double sigma;
    public double n;
    public double diff;
    public double alpha;
    public double df;
    public double power;
    public double delta;
    public int eqs;
    public int eqn;
    public int tt;
    public int opt;
    static /* synthetic */ Class class$rvl$piface$apps$AnovaPicker;

    public void gui() {
        this.bar("sigma", 1.0);
        this.bar("diff", "True |mu - mu_0|", 0.5);
        this.bar("n", 25.0);
        this.beginSubpanel(1, true);
        this.interval("power", 0.5, 0.0, 1.0);
        this.choice("opt", "Solve for", new String[]{"n", "Effect size"}, 0);
        this.endSubpanel();
        this.beginSubpanel(2);
        this.choice("alpha", new double[]{0.005, 0.01, 0.02, 0.05, 0.1, 0.2}, 3);
        this.checkbox("tt", "Two-tailed", 1);
        this.endSubpanel();
        this.menuItem("localHelp", "t test info", this.helpMenu);
    }

    public void click() {
        this.n = OneTGUI.max(OneTGUI.round(this.n), 2.0);
        this.delta = OneTGUI.sqrt(this.n) * this.diff / this.sigma;
        this.power = T.power(this.delta, this.n - 1.0, 1 - this.tt, this.alpha);
    }

    public void power_changed() {
        block0 : switch (this.opt) {
            case 0: {
                if (OneTGUI.abs(this.diff) < 0.001 * this.sigma) {
                    return;
                }
                for (int i = 0; i < 3; ++i) {
                    double d = this.n;
                    this.delta = T.delta(this.power, this.n - 1.0, 1 - this.tt, this.alpha);
                    this.n = OneTGUI.pow(this.delta * this.sigma / this.diff, 2.0);
                    if (!Double.isNaN(this.n)) continue;
                    this.n = d;
                    break block0;
                }
                break;
            }
            case 1: {
                double d = this.diff;
                this.delta = T.delta(this.power, this.n - 1.0, 1 - this.tt, this.alpha);
                this.diff = this.sigma * this.delta / OneTGUI.sqrt(this.n);
                if (!Double.isNaN(this.diff)) break;
                this.diff = d;
            }
        }
        this.click();
    }

    public void localHelp() {
        this.showText(class$rvl$piface$apps$AnovaPicker == null ? (class$rvl$piface$apps$AnovaPicker = OneTGUI.class$("rvl.piface.apps.AnovaPicker")) : class$rvl$piface$apps$AnovaPicker, "OneTGUIHelp.txt", "Power analysis help: One-sample t test", 25, 60);
    }

    public OneTGUI() {
        super(title);
    }

    public static void main(String[] stringArray) {
        new OneTGUI();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

