/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import rvl.piface.DoubleComponent;
import rvl.util.Utility;

public class PiDoubleText
extends Component
implements DoubleComponent {
    private String name;
    private String label;
    private double value;
    private int digits;

    public PiDoubleText(String string, String string2, double d, int n) {
        this.setFont(new Font("Serif", 1, 12));
        this.setName(string, string2);
        this.setDigits(n);
    }

    public PiDoubleText(String string, String string2, double d) {
        this(string, string2, d, 4);
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public double getValue() {
        return this.value;
    }

    public void setName(String string, String string2) {
        this.name = string;
        this.label = string2;
        if (this.isValid()) {
            this.repaint();
        }
    }

    public void setValue(double d) {
        this.value = d;
        this.repaint();
    }

    public void setDigits(int n) {
        this.digits = n;
        if (this.isValid()) {
            this.repaint();
        }
    }

    public void addActionListener(ActionListener actionListener) {
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth("m") / 2;
        int n2 = 3 * fontMetrics.getAscent() / 2;
        graphics.drawString(this.label + " = " + Utility.format(this.value, this.digits), n, n2);
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth("m");
        int n2 = fontMetrics.getHeight();
        return new Dimension(fontMetrics.stringWidth(this.label) + this.digits * n, 3 * n2 / 2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }
}

