/*
 * Decompiled with CFR 0.152.
 */
package rvl.awt;

import java.awt.Color;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.util.StringTokenizer;
import rvl.awt.RVLayout;
import rvl.util.Utility;

public class DoubleArrayField
extends Panel {
    private String label;
    private Font font = new Font("Serif", 1, 12);
    private TextField field;

    public DoubleArrayField(String string, double[] dArray) {
        this(string, dArray, 12);
    }

    public DoubleArrayField(String string, double[] dArray, int n) {
        this.setLayout(new RVLayout(2, false, true));
        Label label = new Label(string);
        label.setFont(this.font);
        this.add(label);
        this.field = new TextField(n);
        this.setValue(dArray);
        this.add(this.field);
    }

    public double[] getValue() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.field.getText(), " ,\t");
        int n = stringTokenizer.countTokens();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            String string = stringTokenizer.nextToken();
            dArray[i] = Utility.strtod(string);
        }
        return dArray;
    }

    public void setValue(double[] dArray) {
        String string = "";
        for (int i = 0; i < dArray.length; ++i) {
            string = string + Utility.format(dArray[i], 3) + " ";
        }
        this.field.setText(string);
    }

    public void setEditable(boolean bl) {
        this.field.setEditable(bl);
    }

    public boolean isEditable() {
        return this.field.isEditable();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.field.setBackground(this.field.isEditable() ? Color.white : color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.field.setForeground(color);
    }
}

