/*
 * Decompiled with CFR 0.152.
 */
package rvl.util;

public class LinAlg {
    public static boolean LUInPlace(double[][] dArray, int[] nArray) {
        int n;
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = n3;
            dArray2[n3] = dArray[n3][0];
            n = 1;
            while (n < n2) {
                if (dArray[n3][n] > dArray2[n3]) {
                    dArray2[n3] = dArray[n3][n];
                }
                ++n;
            }
            ++n3;
        }
        n = 0;
        while (n < n2) {
            int n4;
            int n5 = n;
            double d = dArray[nArray[n5]][n] / dArray2[nArray[n5]];
            int n6 = n + 1;
            while (n6 < n2) {
                if (dArray[nArray[n6]][n] / dArray2[nArray[n6]] > d) {
                    n5 = n6;
                    d = dArray[nArray[n5]][n] / dArray2[nArray[n5]];
                }
                ++n6;
            }
            if (n5 != n) {
                n4 = nArray[n];
                nArray[n] = nArray[n5];
                nArray[n5] = n4;
            }
            if (LinAlg.isZero(d)) {
                return false;
            }
            n4 = n + 1;
            while (n4 < n2) {
                double d2 = dArray[nArray[n4]][n] / dArray[nArray[n]][n];
                int n7 = n;
                while (n7 < n2) {
                    double[] dArray3 = dArray[nArray[n4]];
                    int n8 = n7;
                    dArray3[n8] = dArray3[n8] - d2 * dArray[nArray[n]][n7];
                    ++n7;
                }
                dArray[nArray[n4]][n] = d2;
                ++n4;
            }
            ++n;
        }
        return true;
    }

    public static double[] LUSolveInPlace(double[][] dArray, int[] nArray, double[] dArray2) {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = nArray[n2];
                dArray2[n4] = dArray2[n4] - dArray[nArray[n2]][n3] * dArray2[nArray[n3]];
                ++n3;
            }
            ++n2;
        }
        double[] dArray3 = new double[n];
        int n5 = n - 1;
        while (n5 >= 0) {
            dArray3[n5] = dArray2[nArray[n5]];
            int n6 = n5 + 1;
            while (n6 < n) {
                int n7 = n5;
                dArray3[n7] = dArray3[n7] - dArray[nArray[n5]][n6] * dArray3[n6];
                ++n6;
            }
            int n8 = n5;
            dArray3[n8] = dArray3[n8] / dArray[nArray[n5]][n5];
            --n5;
        }
        return dArray3;
    }

    public static double[][] LU(double[][] dArray, int[] nArray) {
        double[][] dArray2 = new double[dArray.length][];
        int n = 0;
        while (n < dArray.length) {
            dArray2[n] = LinAlg.copy(dArray[n]);
            ++n;
        }
        if (LinAlg.LUInPlace(dArray2, nArray)) {
            return dArray2;
        }
        return null;
    }

    public static double[] LUSolve(double[][] dArray, int[] nArray, double[] dArray2) {
        double[] dArray3 = LinAlg.copy(dArray2);
        return LinAlg.LUSolveInPlace(dArray, nArray, dArray3);
    }

    public static double[] copy(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            dArray2[n] = dArray[n];
            ++n;
        }
        return dArray2;
    }

    public static double[][] transpose(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n2][];
        int n3 = 0;
        while (n3 < n2) {
            dArray2[n3] = new double[n];
            int n4 = 0;
            while (n4 < n) {
                dArray2[n3][n4] = dArray[n4][n3];
                ++n4;
            }
            ++n3;
        }
        return dArray2;
    }

    private static boolean isZero(double d) {
        return Math.abs(d) < 1.0E-8;
    }

    public static double[] constant(double d, int n) {
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = d;
            ++n2;
        }
        return dArray;
    }

    public static void print(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            System.out.print(" " + dArray[n]);
            ++n;
        }
    }

    public static void println(double[] dArray) {
        LinAlg.print(dArray);
        System.out.println();
    }

    public static void println(double[][] dArray) {
        int n = 0;
        while (n < dArray.length) {
            LinAlg.println(dArray[n]);
            ++n;
        }
    }
}

