/*
 * Decompiled with CFR 0.152.
 */
package rvl.stat.dist;

import rvl.util.UniFunction;

class BinomialAux
extends UniFunction {
    private double p0;
    private double n;

    public BinomialAux(double d, double d2) {
        this.p0 = d;
        this.n = d2;
        this.closedMax = true;
        this.closedMin = true;
        this.xMin = 0.0;
        this.xMax = 1.0;
    }

    public double of(double d) {
        d = Math.max(0.0, Math.min(1.0, d));
        double d2 = Math.max(Math.abs(d - this.p0), 0.01);
        double d3 = Math.max(Math.sqrt(d * (1.0 - d) / this.n), d2 / 1000.0);
        return (d - this.p0) / d3;
    }
}

