/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface.apps;

import rvl.piface.Piface;
import rvl.stat.dist.Normal;

public class TwoPGUI
extends Piface {
    private static String title = "Test of equality of two proportions";
    public double p1;
    public double p2;
    public double n1;
    public double n2;
    public double Alpha;
    public double Power;
    public int eq;
    public int alt;
    public int cc;
    static /* synthetic */ Class class$rvl$piface$apps$AnovaPicker;

    public void gui() {
        this.beginSubpanel(1, true);
        this.interval("p1", 0.5, 0.0, 1.0);
        this.interval("p2", 0.6, 0.0, 1.0);
        this.endSubpanel();
        this.beginSubpanel(1, true);
        this.bar("n1", 100.0);
        this.bar("n2", 100.0);
        this.checkbox("eq", "Equal ns", 1);
        this.endSubpanel();
        this.beginSubpanel(1, true);
        this.bar("Alpha", 0.05);
        this.ointerval("Power", 0.5, 0.0, 1.0);
        this.endSubpanel();
        this.beginSubpanel(2);
        this.checkbox("cc", "Continuity corr.", 1);
        this.choice("alt", "Alternative", new String[]{"p1 < p2", "p1 != p2", "p1 > p2"}, 1);
        this.endSubpanel();
        this.menuItem("localHelp", "This dialog", this.helpMenu);
    }

    public void click() {
        this.n1 = TwoPGUI.max(2.0, TwoPGUI.round(this.n1));
        if (this.eq == 1) {
            this.n2 = this.n1;
        }
        double d = 5.0 / this.n1;
        double d2 = 5.0 / this.n1;
        this.p1 = TwoPGUI.min(TwoPGUI.max(this.p1, d), 1.0 - d);
        this.p2 = TwoPGUI.min(TwoPGUI.max(this.p2, d2), 1.0 - d2);
        this.calcPower();
    }

    public void n2_changed() {
        this.n2 = TwoPGUI.max(TwoPGUI.round(this.n2), 2.0);
        if (this.eq == 1) {
            this.n1 = this.n2;
        }
        this.calcPower();
    }

    private void calcPower() {
        double d = (this.n1 * this.p1 + this.n2 * this.p2) / (this.n1 + this.n2);
        double d2 = TwoPGUI.sqrt(d * (1.0 - d) * (1.0 / this.n1 + 1.0 / this.n2));
        double d3 = TwoPGUI.sqrt(this.p1 * (1.0 - this.p1) / this.n1 + this.p2 * (1.0 - this.p2) / this.n2);
        double d4 = this.p1 - this.p2;
        double d5 = TwoPGUI.min(TwoPGUI.abs(d4), 0.5 * (1.0 / this.n1 + 1.0 / this.n2));
        this.Alpha = TwoPGUI.max(1.0E-6, TwoPGUI.min(this.Alpha, 0.999999));
        if (this.cc == 1) {
            d4 = d4 > 0.0 ? d4 - d5 : d4 + d5;
        }
        this.Power = Normal.power(d4 / d2, this.alt - 1, this.Alpha, d3 / d2);
    }

    public void localHelp() {
        this.showText(class$rvl$piface$apps$AnovaPicker == null ? (class$rvl$piface$apps$AnovaPicker = TwoPGUI.class$("rvl.piface.apps.AnovaPicker")) : class$rvl$piface$apps$AnovaPicker, "TwoPGUIHelp.txt", "Power analysis help: Comparing two proportions", 25, 60);
    }

    public TwoPGUI() {
        super(title);
    }

    public static void main(String[] stringArray) {
        new TwoPGUI();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

