import argparse


from sub2vec import sub2vec


def main():
    parser = argparse.ArgumentParser(description="sub2vec.")
    parser.add_argument('--input', nargs='?', required=True, help='Input directory')
    

    parser.add_argument('--walkLength', default=1000, type=int, help='length of random walk on each subgraph')

    parser.add_argument('--output', required=True, help='Output representation file')

    parser.add_argument('--d', default=128, type=int, help='dimension of learned feautures for each subgraph.')
    
    parser.add_argument('--iter', default=10, type=int, help= 'training iterations')

    parser.add_argument('--windowSize', default=5, type=int,
                      help='Window size of the model.')

    parser.add_argument('--model', default='dm', choices=['dbon', 'dm'],
                      help='models for learninig vectors SV-DM (dm) or SV-DBON (dbon).')
                      
    args = parser.parse_args()
    sub2vec(args)
    


if __name__=='__main__':
    main()